--------------------------------------------------------------------------------
--AG: 30.05.2006
-- :  (behavior = sniper)
--1.     ( CQB: cqb_distance)   
--2.                  (tries, far_distance).
--3.               (far_distance).
--4.     5    .
--5.         ,     -    .
--------------------------------------------------------------------------------

b_sniper = 
{
	selectMoveDistFromStrategy = function(strategy)
		local movedist = getAIConst().sniperMaxMoveDist
		if(isGameInRT()) then
			strategy = math.random(0,3)	
		end
		if(strategy == 1) then
			movedist = getAIConst().sniperMedMoveDist
		elseif(strategy == 2) then
			movedist = getAIConst().sniperDefMoveDist
		elseif(strategy > 2) then
			movedist = getAIConst().sniperMinMoveDist
		end
		return(movedist)
	end,

----------------------------
--SOLDIER SNIPER BEHAVIOR--
----------------------------
	think = function(id, strategy, visible_target)
		log(id, " ")
calls.enter("b_sniper.think",id..","..strategy..","..visible_target)
		local attacks_before_shift = getAIConst().sniperMaxAttacks	--       
		local tries = getAIConst().sniperMaxMissTries			--           

		log(id, " :", visible_target)

		if not(service.isTargetDangerous(visible_target)) then
			log(id, " ", visible_target," .   .")
			local dangerous_target = service.closestDangerousEnemy(id)

			if(isUnitValid(dangerous_target)) then
				log(id, "  ", dangerous_target, "  ")
				visible_target = dangerous_target
			else
				log(id, "  .    .")
				if(math.random()<0.5) then
					log(id, "Try melee attack target")
					b_soldier.attackTargetByMelee(id,visible_target,"HAND_ATTACK")
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
        				return 1
				end
			end
		else
			log(id, " ", visible_target, "")
		end

		local tx, ty, tz, tf = getPosition(visible_target)
		local dist = service.person2person_distance(id, visible_target)
		local movedist = b_sniper.selectMoveDistFromStrategy(strategy)

		if (Humans[id].shift > attacks_before_shift) then
			Humans[id].shift = 0
		end

		local isNewTarget = false
		if (Humans[id].shift == 0) then
		--  
			log(id, " ")
			addRotate(id,tx, ty, tz)
			movedist = movedist * 3
			local dir = "left"
			if (math.random() > 0.5) then
				dir = "right"
			end
			local nx, ny, nz, nf = service.randomSidePoint(id, dir, movedist)
			addSmartMove(id, "run", nx, ny, nz, nf)
			Humans[id].moveonly = true
			Humans[id].attacked = false
			Humans[id].shift = 1
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
			return 1
		else
		-- 
			if((not isUnitValid(Humans[id].current_target)) or (visible_target ~= Humans[id].current_target)) then
				log(id, "  ")
				isNewTarget = true
				Humans[id].current_target = visible_target
				Humans[id].target_health = getPersonParameter(visible_target, "HEALTH")
				Humans[id].try = 0
				Humans[id].attacked = false
				Humans[id].shift = 1
			elseif (visible_target == Humans[id].current_target) then
				log(id, "      ")
				local target_health = getPersonParameter(visible_target, "HEALTH")
				if (Humans[id].target_health > target_health) then
					log(id, "  !")
					if (Humans[id].attacked) then
						log(id, "  !    !")
						Humans[id].shift = Humans[id].shift + 1
						Humans[id].try = 0
						Humans[id].target_health = target_health
					else
						log(id, "   - !")
					end
				else
					log(id, "   !")
					if(Humans[id].attacked) then
						log(id, "        !")

						Humans[id].shift = Humans[id].shift + 1
						Humans[id].try = Humans[id].try + 1

						if(not inRange(id, visible_target)) then
							log(id, "   ,   ")
							local nx, ny, nz = service.pointAlongPersonToPersonLine(visible_target, id, movedist)
							Humans[id].try = 0
							Humans[id].shift = 1
							addSmartMove(id, "sneak", nx, ny, nz, 1)
							Humans[id].moveonly = true
							Humans[id].attacked = false
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
							return 1
						elseif((dist < grenadeMaxDistance(id)) and (takeAP(id)>10)) then
							if(not b_soldier.attackTargetByGrenade(id,visible_target)) then
								log(id, "  , ")
								local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
								local nx, ny, nz = service.pointAlongPersonToPersonLine(visible_target, id, -1*movedist)
								Humans[id].try = 0
								Humans[id].shift = 1
								addSmartMove(id, "run", nx, ny, nz, 1)
								if(b_soldier.isLastMove(id,strategy,movedist)) then
									addPose(id, "sit")
									Humans[id].turnDone = true
								end
								Humans[id].moveonly = true
								Humans[id].attacked = false
							end	
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
							return 1
						elseif(Humans[id].try < tries) then
							log(id, "    ")
						else
							log(id, " ,   ")
							Humans[id].current_target = NONE
							Humans[id].target_health = 0
							Humans[id].shift = 0
							Humans[id].attacked = false
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
							return 2
						end
					else
						log(id, "       ")
					end
				end
			end
			if(service.isFriendInLos(id, visible_target)) then
				Humans[id].current_target = NONE
				Humans[id].target_health = 0
				Humans[id].shift = 0
				Humans[id].attacked = false
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
				return 2
			end
			if((not isNewTarget) and (getPersonPose(id) == "stand")) then
				addPose(id, "sit")
			end
			service.selectFireMode(id, visible_target, dist, strategy)
			local aimLevel = b_soldier.selectAimLevelFromStrategy(id,dist,strategy)		
			log(id, "  :", aimLevel)
			attackTarget(id, visible_target, aimLevel)
			if((strategy >= getAIConst().maxStrategy) and (getPersonPose(id) == "stand")) then
 				log(id,"**** max strategy, sitdown")
				addPose(id, "sit")
			end
			Humans[id].attacked = true
			Humans[id].moveonly = false
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
			return 1
		end
calls.leave("b_sniper.think",id..","..strategy..","..visible_target)
		return 0
	end,
------------------------------------------------------------------------------------------	
}